/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.components;

import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.ColorConstraint;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.state.ExtensionsKt;
import gg.essential.elementa.state.State;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J5\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0010\u00a2\u0006\u0002\b\u0015\u00a8\u0006\u0017"}, d2={"Lgg/essential/elementa/components/UIBlock;", "Lgg/essential/elementa/UIComponent;", "color", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "colorState", "Lgg/essential/elementa/state/State;", "(Lgg/essential/elementa/state/State;)V", "colorConstraint", "Lgg/essential/elementa/constraints/ColorConstraint;", "(Lgg/essential/elementa/constraints/ColorConstraint;)V", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawBlock", "x", "", "y", "x2", "y2", "drawBlock$Elementa", "Companion", "Elementa"})
public class UIBlock
extends UIComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public UIBlock(@NotNull ColorConstraint colorConstraint) {
        Intrinsics.checkNotNullParameter(colorConstraint, "colorConstraint");
        this.setColor(colorConstraint);
    }

    public /* synthetic */ UIBlock(ColorConstraint colorConstraint, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            colorConstraint = UtilitiesKt.toConstraint(color);
        }
        this(colorConstraint);
    }

    public UIBlock(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        this(UtilitiesKt.toConstraint(color));
    }

    public UIBlock(@NotNull State<Color> colorState2) {
        Intrinsics.checkNotNullParameter(colorState2, "colorState");
        this(ExtensionsKt.toConstraint(colorState2));
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        this.beforeDrawCompat(matrixStack);
        double x = this.getLeft();
        double y = this.getTop();
        double x2 = this.getRight();
        double y2 = this.getBottom();
        this.drawBlock$Elementa(matrixStack, x, y, x2, y2);
        super.draw(matrixStack);
    }

    public void drawBlock$Elementa(@NotNull UMatrixStack matrixStack, double x, double y, double x2, double y2) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            return;
        }
        Companion.drawBlock(matrixStack, color, x, y, x2, y2);
    }

    public UIBlock() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0007J6\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fJ0\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0007J6\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f\u00a8\u0006\u0016"}, d2={"Lgg/essential/elementa/components/UIBlock$Companion;", "", "()V", "drawBlock", "", "worldRenderer", "Lgg/essential/universal/UGraphics;", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "color", "Ljava/awt/Color;", "x1", "", "y1", "x2", "y2", "drawBlockSized", "x", "y", "width", "height", "drawBlockWithActiveShader", "Elementa"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Pass UMatrixStack as first argument, required for 1.17", replaceWith=@ReplaceWith(expression="drawBlock(matrixStack, color, x1, y1, x2, y2)", imports={}))
        public final void drawBlock(@NotNull Color color, double x1, double y1, double x2, double y2) {
            Intrinsics.checkNotNullParameter(color, "color");
            this.drawBlock(new UMatrixStack(), color, x1, y1, x2, y2);
        }

        public final void drawBlock(@NotNull UMatrixStack matrixStack, @NotNull Color color, double x1, double y1, double x2, double y2) {
            Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
            Intrinsics.checkNotNullParameter(color, "color");
            UGraphics.enableBlend();
            UGraphics.tryBlendFuncSeparate(770, 771, 1, 0);
            UGraphics buffer = UGraphics.getFromTessellator();
            buffer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
            Intrinsics.checkNotNullExpressionValue(buffer, "buffer");
            this.drawBlock(buffer, matrixStack, color, x1, y1, x2, y2);
            UGraphics.disableBlend();
        }

        public final void drawBlockWithActiveShader(@NotNull UMatrixStack matrixStack, @NotNull Color color, double x1, double y1, double x2, double y2) {
            Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
            Intrinsics.checkNotNullParameter(color, "color");
            UGraphics buffer = UGraphics.getFromTessellator();
            buffer.beginWithActiveShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
            Intrinsics.checkNotNullExpressionValue(buffer, "buffer");
            this.drawBlock(buffer, matrixStack, color, x1, y1, x2, y2);
        }

        private final void drawBlock(UGraphics worldRenderer, UMatrixStack matrixStack, Color color, double x1, double y1, double x2, double y2) {
            float red = (float)color.getRed() / 255.0f;
            float green = (float)color.getGreen() / 255.0f;
            float blue = (float)color.getBlue() / 255.0f;
            float alpha = (float)color.getAlpha() / 255.0f;
            worldRenderer.pos(matrixStack, x1, y2, 0.0).color(red, green, blue, alpha).endVertex();
            worldRenderer.pos(matrixStack, x2, y2, 0.0).color(red, green, blue, alpha).endVertex();
            worldRenderer.pos(matrixStack, x2, y1, 0.0).color(red, green, blue, alpha).endVertex();
            worldRenderer.pos(matrixStack, x1, y1, 0.0).color(red, green, blue, alpha).endVertex();
            if (ElementaVersion.Companion.getActive().compareTo((Enum)ElementaVersion.Companion.getV1$Elementa()) >= 0) {
                UGraphics.enableDepth();
                UGraphics.depthFunc(519);
                worldRenderer.drawDirect();
                UGraphics.disableDepth();
                UGraphics.depthFunc(515);
            } else {
                worldRenderer.drawDirect();
            }
        }

        @Deprecated(message="Pass UMatrixStack as first argument, required for 1.17", replaceWith=@ReplaceWith(expression="drawBlock(matrixStack, color, x1, y1, x2, y2)", imports={}))
        public final void drawBlockSized(@NotNull Color color, double x, double y, double width, double height) {
            Intrinsics.checkNotNullParameter(color, "color");
            this.drawBlockSized(new UMatrixStack(), color, x, y, width, height);
        }

        public final void drawBlockSized(@NotNull UMatrixStack matrixStack, @NotNull Color color, double x, double y, double width, double height) {
            Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
            Intrinsics.checkNotNullParameter(color, "color");
            this.drawBlock(matrixStack, color, x, y, x + width, y + height);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

